<?php



/*

 * This file is part of the Symfony package.

 *

 * (c) Fabien Potencier <fabien@symfony.com>

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



namespace Symfony\Component\HttpKernel\DependencyInjection;



use Symfony\Component\DependencyInjection\Extension\Extension as BaseExtension;



/**

 * Allow adding classes to the class cache.

 *

 * @author Fabien Potencier <fabien@symfony.com>

 */

abstract class Extension extends BaseExtension

{

    private $classes = array();



    /**

     * Gets the classes to cache.

     *

     * @return array An array of classes

     */

    public function getClassesToCompile()

    {

        return $this->classes;

    }



    /**

     * Adds classes to the class cache.

     *

     * @param array $classes An array of classes

     */

    public function addClassesToCompile(array $classes)

    {

        $this->classes = array_merge($this->classes, $classes);

    }

}

