<?php



/*

 * This file is part of the Symfony package.

 *

 * (c) Fabien Potencier <fabien@symfony.com>

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



namespace Symfony\Component\CssSelector\XPath\Extension;



/**

 * XPath expression translator extension interface.

 *

 * This component is a port of the Python cssselector library,

 * which is copyright Ian Bicking, @see https://github.com/SimonSapin/cssselect.

 *

 * @author Jean-François Simon <jeanfrancois.simon@sensiolabs.com>

 */

interface ExtensionInterface

{

    /**

     * Returns node translators.

     *

     * @return callable[]

     */

    public function getNodeTranslators();



    /**

     * Returns combination translators.

     *

     * @return callable[]

     */

    public function getCombinationTranslators();



    /**

     * Returns function translators.

     *

     * @return callable[]

     */

    public function getFunctionTranslators();



    /**

     * Returns pseudo-class translators.

     *

     * @return callable[]

     */

    public function getPseudoClassTranslators();



    /**

     * Returns attribute operation translators.

     *

     * @return callable[]

     */

    public function getAttributeMatchingTranslators();



    /**

     * Returns extension name.

     *

     * @return string

     */

    public function getName();

}

