<?php



/*

 * This file is part of the Symfony package.

 *

 * (c) Fabien Potencier <fabien@symfony.com>

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



namespace Symfony\Component\Console\Helper;



/**

 * HelperInterface is the interface all helpers must implement.

 *

 * @author Fabien Potencier <fabien@symfony.com>

 *

 * @api

 */

interface HelperInterface

{

    /**

     * Sets the helper set associated with this helper.

     *

     * @param HelperSet $helperSet A HelperSet instance

     *

     * @api

     */

    public function setHelperSet(HelperSet $helperSet = null);



    /**

     * Gets the helper set associated with this helper.

     *

     * @return HelperSet A HelperSet instance

     *

     * @api

     */

    public function getHelperSet();



    /**

     * Returns the canonical name of this helper.

     *

     * @return string The canonical name

     *

     * @api

     */

    public function getName();

}

