<?php



/*

 * This file is part of the Predis package.

 *

 * (c) Daniele Alessandri <suppakilla@gmail.com>

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



namespace Predis\Command;



/**

 * @link http://redis.io/commands/evalsha

 * @author Daniele Alessandri <suppakilla@gmail.com>

 */

class ServerEvalSHA extends ServerEval

{

    /**

     * {@inheritdoc}

     */

    public function getId()

    {

        return 'EVALSHA';

    }



    /**

     * Returns the SHA1 hash of the body of the script.

     *

     * @return string SHA1 hash.

     */

    public function getScriptHash()

    {

        return $this->getArgument(0);

    }

}

