<?php



/*

 * This file is part of the Predis package.

 *

 * (c) Daniele Alessandri <suppakilla@gmail.com>

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



namespace Predis\Command;



/**

 * Base class for Redis commands with prefixable keys.

 *

 * @author Daniele Alessandri <suppakilla@gmail.com>

 */

abstract class PrefixableCommand extends AbstractCommand implements PrefixableCommandInterface

{

    /**

     * {@inheritdoc}

     */

    public function prefixKeys($prefix)

    {

        if ($arguments = $this->getArguments()) {

            $arguments[0] = "$prefix{$arguments[0]}";

            $this->setRawArguments($arguments);

        }

    }

}

