<?php



/*

 * This file is part of the Predis package.

 *

 * (c) Daniele Alessandri <suppakilla@gmail.com>

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



namespace Predis\Command;



/**

 * @link http://redis.io/commands/blpop

 * @author Daniele Alessandri <suppakilla@gmail.com>

 */

class ListPopFirstBlocking extends AbstractCommand implements PrefixableCommandInterface

{

    /**

     * {@inheritdoc}

     */

    public function getId()

    {

        return 'BLPOP';

    }



    /**

     * {@inheritdoc}

     */

    protected function filterArguments(Array $arguments)

    {

        if (count($arguments) === 2 && is_array($arguments[0])) {

            list($arguments, $timeout) = $arguments;

            array_push($arguments, $timeout);

        }



        return $arguments;

    }



    /**

     * {@inheritdoc}

     */

    public function prefixKeys($prefix)

    {

        PrefixHelpers::skipLast($this, $prefix);

    }

}

