<?php

/*

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS

 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT

 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR

 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT

 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,

 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT

 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,

 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY

 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT

 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE

 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 *

 * This software consists of voluntary contributions made by many individuals

 * and is licensed under the MIT license. For more information, see

 * <http://www.doctrine-project.org>.

 */



namespace Doctrine\DBAL\Platforms;



/**

 * Platform to ensure compatibility of Doctrine with Microsoft SQL Server 2005 version and

 * higher.

 *

 * Differences to SQL Server 2008 are:

 *

 * - DATETIME2 datatype does not exist, only DATETIME which has a precision of

 *   3. This is not supported by PHP DateTime, so we are emulating it by

 *   setting .000 manually.

 * - Starting with SQLServer2005 VARCHAR(MAX), VARBINARY(MAX) and

 *   NVARCHAR(max) replace the old TEXT, NTEXT and IMAGE types. See

 *   {@link http://www.sql-server-helper.com/faq/sql-server-2005-varchar-max-p01.aspx}

 *   for more information.

 */

class SQLServer2005Platform extends SQLServerPlatform

{

    /**

     * {@inheritDoc}

     */

    public function supportsLimitOffset()

    {

        return true;

    }



    /**

     * {@inheritDoc}

     */

    public function getClobTypeDeclarationSQL(array $field)

    {

        return 'VARCHAR(MAX)';

    }



    /**

     * {@inheritdoc}

     *

     * Returns Microsoft SQL Server 2005 specific keywords class

     */

    protected function getReservedKeywordsClass()

    {

        return 'Doctrine\DBAL\Platforms\Keywords\SQLServer2005Keywords';

    }

}

