<?php

/*

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS

 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT

 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR

 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT

 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,

 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT

 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,

 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY

 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT

 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE

 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 *

 * This software consists of voluntary contributions made by many individuals

 * and is licensed under the MIT license. For more information, see

 * <http://www.doctrine-project.org>.

 */



namespace Doctrine\DBAL\Platforms\Keywords;



/**

 * SQLite Keywordlist.

 *

 * @link   www.doctrine-project.org

 * @since  2.0

 * @author Benjamin Eberlei <kontakt@beberlei.de>

 */

class SQLiteKeywords extends KeywordList

{

    /**

     * {@inheritdoc}

     */

    public function getName()

    {

        return 'SQLite';

    }



    /**

     * {@inheritdoc}

     */

    protected function getKeywords()

    {

        return array(

            'ABORT',

            'ACTION',

            'ADD',

            'AFTER',

            'ALL',

            'ALTER',

            'ANALYZE',

            'AND',

            'AS',

            'ASC',

            'ATTACH',

            'AUTOINCREMENT',

            'BEFORE',

            'BEGIN',

            'BETWEEN',

            'BY',

            'CASCADE',

            'CASE',

            'CAST',

            'CHECK',

            'COLLATE',

            'COLUMN',

            'COMMIT',

            'CONFLICT',

            'CONSTRAINT',

            'CREATE',

            'CROSS',

            'CURRENT_DATE',

            'CURRENT_TIME',

            'CURRENT_TIMESTAMP',

            'DATABASE',

            'DEFAULT',

            'DEFERRABLE',

            'DEFERRED',

            'DELETE',

            'DESC',

            'DETACH',

            'DISTINCT',

            'DROP',

            'EACH',

            'ELSE',

            'END',

            'ESCAPE',

            'EXCEPT',

            'EXCLUSIVE',

            'EXISTS',

            'EXPLAIN',

            'FAIL',

            'FOR',

            'FOREIGN',

            'FROM',

            'FULL',

            'GLOB',

            'GROUP',

            'HAVING',

            'IF',

            'IGNORE',

            'IMMEDIATE',

            'IN',

            'INDEX',

            'INDEXED',

            'INITIALLY',

            'INNER',

            'INSERT',

            'INSTEAD',

            'INTERSECT',

            'INTO',

            'IS',

            'ISNULL',

            'JOIN',

            'KEY',

            'LEFT',

            'LIKE',

            'LIMIT',

            'MATCH',

            'NATURAL',

            'NO',

            'NOT',

            'NOTNULL',

            'NULL',

            'OF',

            'OFFSET',

            'ON',

            'OR',

            'ORDER',

            'OUTER',

            'PLAN',

            'PRAGMA',

            'PRIMARY',

            'QUERY',

            'RAISE',

            'REFERENCES',

            'REGEXP',

            'REINDEX',

            'RELEASE',

            'RENAME',

            'REPLACE',

            'RESTRICT',

            'RIGHT',

            'ROLLBACK',

            'ROW',

            'SAVEPOINT',

            'SELECT',

            'SET',

            'TABLE',

            'TEMP',

            'TEMPORARY',

            'THEN',

            'TO',

            'TRANSACTION',

            'TRIGGER',

            'UNION',

            'UNIQUE',

            'UPDATE',

            'USING',

            'VACUUM',

            'VALUES',

            'VIEW',

            'VIRTUAL',

            'WHEN',

            'WHERE'

        );

    }

}

