<?php

/*

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS

 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT

 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR

 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT

 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,

 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT

 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,

 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY

 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT

 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE

 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 *

 * This software consists of voluntary contributions made by many individuals

 * and is licensed under the MIT license. For more information, see

 * <http://www.doctrine-project.org>.

 */



namespace Doctrine\Common\Reflection;



use ReflectionProperty;

use Doctrine\Common\Proxy\Proxy;



/**

 * PHP Runtime Reflection Public Property - special overrides for public properties.

 *

 * @author Marco Pivetta <ocramius@gmail.com>

 * @since  2.4

 */

class RuntimePublicReflectionProperty extends ReflectionProperty

{

    /**

     * {@inheritDoc}

     *

     * Checks is the value actually exist before fetching it.

     * This is to avoid calling `__get` on the provided $object if it

     * is a {@see \Doctrine\Common\Proxy\Proxy}.

     */

    public function getValue($object = null)

    {

        $name = $this->getName();



        if ($object instanceof Proxy && ! $object->__isInitialized()) {

            $originalInitializer = $object->__getInitializer();

            $object->__setInitializer(null);

            $val = isset($object->$name) ? $object->$name : null;

            $object->__setInitializer($originalInitializer);



            return $val;

        }



        return isset($object->$name) ? parent::getValue($object) : null;

    }



    /**

     * {@inheritDoc}

     *

     * Avoids triggering lazy loading via `__set` if the provided object

     * is a {@see \Doctrine\Common\Proxy\Proxy}.

     * @link https://bugs.php.net/bug.php?id=63463

     */

    public function setValue($object, $value = null)

    {

        if ( ! ($object instanceof Proxy && ! $object->__isInitialized())) {

            parent::setValue($object, $value);



            return;

        }



        $originalInitializer = $object->__getInitializer();

        $object->__setInitializer(null);

        parent::setValue($object, $value);

        $object->__setInitializer($originalInitializer);

    }

}

