<?php

/*

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS

 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT

 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR

 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT

 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,

 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT

 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,

 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY

 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT

 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE

 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 *

 * This software consists of voluntary contributions made by many individuals

 * and is licensed under the MIT license. For more information, see

 * <http://www.doctrine-project.org>.

 */



namespace Doctrine\Common\Reflection;



/**

 * Finds a class in a PSR-0 structure.

 *

 * @author Karoly Negyesi <karoly@negyesi.net>

 */

class Psr0FindFile implements ClassFinderInterface

{

    /**

     * The PSR-0 prefixes.

     *

     * @var array

     */

    protected $prefixes;



    /**

     * @param array $prefixes An array of prefixes. Each key is a PHP namespace and each value is

     *                        a list of directories.

     */

    public function __construct($prefixes)

    {

        $this->prefixes = $prefixes;

    }



    /**

     * {@inheritDoc}

     */

    public function findFile($class)

    {

        $lastNsPos = strrpos($class, '\\');

        if ('\\' == $class[0]) {

            $class = substr($class, 1);

        }



        if (false !== $lastNsPos) {

            // namespaced class name

            $classPath = str_replace('\\', DIRECTORY_SEPARATOR, substr($class, 0, $lastNsPos)) . DIRECTORY_SEPARATOR;

            $className = substr($class, $lastNsPos + 1);

        } else {

            // PEAR-like class name

            $classPath = null;

            $className = $class;

        }



        $classPath .= str_replace('_', DIRECTORY_SEPARATOR, $className) . '.php';



        foreach ($this->prefixes as $prefix => $dirs) {

            if (0 === strpos($class, $prefix)) {

                foreach ($dirs as $dir) {

                    if (is_file($dir . DIRECTORY_SEPARATOR . $classPath)) {

                        return $dir . DIRECTORY_SEPARATOR . $classPath;

                    }

                }

            }

        }



        return null;

    }

}

