@extends('layouts.wrap')
@section('title','Özgün Tarım - '. $page->title)
@section('foot_hook')
@parent
    {{HTML::script('static/plugin/select2/select2.js')}}
    <script>
        $(document).ready(function(){
            $('#aydi').select2();
        });
    </script>
@stop
@section('head_hook')
@parent
{{HTML::style('static/plugin/select2/select2.css')}}
    {{HTML::style('static/plugin/select2/select2-bootstrap.css')}}
@stop
@section('_content')
<div class="container page order" id="content">







    <h2 class="title">Sipariş Talep Formu</h2>







    <div class="order-page">



  <div class="row">







      <div class="col-md-6">











          @if(Session::has('message'))







            <div class="alert alert-success">



                {{ Session::get('message') }}



            </div>











          @else











          {{ Former::open()->method('POST')->action(URL::to('siparis')) }}







          {{ Former::text('name')->placeholder('İsim - Soyisim')->required(true)->label(false) }}







          {{ Former::email('email')->placeholder('E-Posta Adresiniz')->label(false) }}







          {{ Former::text('company')->placeholder('Firma Adı')->required(true)->label(false) }}







          {{ Former::text('phone')->placeholder('Telefon Numaranız')->required(true)->label(false) }}







          {{ Former::text('address')->placeholder('Adresiniz')->label(false) }}







          <div class="form-group">







              <select data-placeholder="İstediğiniz Ürünü Seçiniz.. (birden fazla ürün seçebilirsiniz)" id="aydi" multiple class="form-control" name="product">



                  @foreach(Product::orderBy('title')->get() as $product)







                        <option>{{ $product->title }}</option>





                  @endforeach



              </select>







          </div>







          {{ Former::textarea('message')->placeholder('Notunuz')->label(false)->rows(7) }}







            <button type="submit" class="btn btn-default">Gönder</button>







          {{ Former::close() }}







          @endif











      </div>







      <div class="col-md-6 text-center">





          <span style="background-color: white; padding: 10px; color: black; position: relative; top:5px;">BANKA HESAP BİLGİLERİMİZ</span>



          <ul class="list-unstyled bank">



              @foreach(OrderBank::all() as $bank)



              <li style="margin-top: 30px;margin-bottom: 20px; border-bottom: 1px solid #4d747b; padding-bottom: 20px;"><h4>{{ $bank->title }}</h4>



                  {{ nl2br($bank->value) }}



              </li>



              @endforeach



          </ul>



      </div>









  </div>



    </div>







</div>











@stop