<?php

Route::controller('references', 'ReferencesController');


Route::group(array('domain' => 'admin.'.Option::value('domain')), function()

{

    if( Request::getHost() == 'admin.'.Option::value('domain') ) View::addLocation(app('path').'/views/admin/'.Option::value('adminTheme'));



    Route::group(array('before' => 'auth|admin'), function()

    {

        Route::get('/', array('uses' => 'Admin_HomeController@index'));

        Route::get('setlang', array('uses' => 'Admin_HomeController@setlang'));

        Route::get('logout', array('uses' => 'LoginController@logout'));

        Route::Controller('option', 'Admin_OptionController');

    });



    Route::get('login', array('before' => 'guest', 'uses' => 'LoginController@login'));

    Route::post('login', array('before' => 'guest', 'uses' => 'LoginController@postlogin'));

});





Route::group(array('domain' => Option::value('domain')), function()

{

    View::addLocation(app('path').'/views/public/'.Option::value('publicTheme'));

	 Route::get('news/{id}', array('uses' => 'Public_HomeController@news'));

    Route::get('/', array('uses' => 'Public_HomeController@index'));

});



Route::group(array('domain' => 'www.'.Option::value('domain')), function()

{

    View::addLocation(app('path').'/views/public/'.Option::value('publicTheme'));

	 Route::get('news/{id}', array('uses' => 'Public_HomeController@news'));

    Route::get('/', array('uses' => 'Public_HomeController@index'));

});
















