<?php



use Illuminate\Database\Schema\Blueprint;

use Illuminate\Database\Migrations\Migration;



class InstallCMS extends Migration {



	/**

	 * Run the migrations.

	 *

	 * @return void

	 */

	public function up()

	{

        Schema::create('users', function($table)

        {

            $table->increments('id');

            $table->string('email', 100);

            $table->string('password');

            $table->string('name');

            $table->integer('is_admin');

            $table->integer('role');

            $table->string('avatar')->nullable();

            $table->string('remember_token');

            $table->softDeletes();

            $table->timestamps();

        });



        Schema::create('options', function($table)

        {

            $table->increments('id');

            $table->text('option');

            $table->text('value')->nullable();

            $table->integer('type');

            $table->softDeletes();

            $table->timestamps();

        });



        Schema::create('langs', function($table)

        {

            $table->increments('id');

            $table->string('lang');

            $table->string('folder');

            $table->softDeletes();

            $table->timestamps();

        });



        Schema::create('pages', function($table)

        {

            $table->increments('id');

            $table->string('title');

            $table->string('description')->nullable();

            $table->text('value');

            $table->integer('lang');

            $table->softDeletes();

            $table->timestamps();

        });



        Schema::create('menus', function($table)

        {

            $table->increments('id');

            $table->string('value');

            $table->string('url');

            $table->integer('parent');

            $table->integer('lang');

            $table->softDeletes();

            $table->timestamps();

        });



        Schema::create('sessions', function($table)

        {

            $table->string('id')->unique();

            $table->text('payload');

            $table->integer('last_activity');

        });





        User::create([

            'email' => 'admin@vairosoft.com',

            'password' => Hash::make('admin'),

            'name' => 'Vairosoft',

            'is_admin' => 1

        ]);





        Option::create([

            'option' => 'domain',

            'value' => 'cms.dev'

        ]);



        Option::create([

            'option' => 'siteTitle',

            'value' => 'Vairosoft CMS'

        ]);



        Option::create([

            'option' => 'siteDescription',

            'value' => 'vairosoft cms'

        ]);



        Option::create([

            'option' => 'theme',

            'value' => 'default'

        ]);





	}



	public function down()

	{

		//

	}



}

