@extends('layouts.wrap')



@section('title', 'Slider')





@include('slider::sidebar')





@section('_content')

<div id="component_page">

    <h1 class="title">Slider Komponenti</h1>



    @if(Session::has('message'))

    <div class="alert alert-success">{{ Session::get('message') }}</div>

    @endif

    @if($slider->count() > 0)

    <table class="table table-hover table-striped">

        <thead>

        <tr>

            <th>Başlık</th>

            <th>URL</th>

        </tr>

        </thead>

        <tbody>

        @foreach($slider as $s)

        <tr>

            <td><a href="{{ URL::to('component/slider/edit/'. $s->id) }}">{{ $s->title }}<a></td>

            <td>{{ $s->url }}</td>

        </tr>

        @endforeach

        </tbody>

    </table>



    {{ $slider->links() }}

    @else

    <div class="alert alert-warning">

        <h4>Hiç Slideriniz yok.</h4> <a href="{{ URL::to('component/slider/create') }}" class="alert-link">Buradan ekleyin</a>

    </div>

    @endif





</div>



@stop