<?php

class SliderController extends \BaseController {

	public function getIndex(){
        $data['slider'] = Slider::paginate(Option::value('admin_paginate'));
        return View::make('slider::home', $data);
    }


    public function getCreate(){
        return View::make('slider::create');
    }

    public function postCreate(){

        $validator = Validator::make(Input::all(), [
            'background' => 'required|image',
			'background2' => 'required|image'
        ]);

        if($validator->passes()){
            $filename = str_random(16);
            Input::file('background')->move('modules/slider/slider/', $filename.'.'.Input::file('background')->getClientOriginalExtension());
            Image::open('modules/slider/slider/'.$filename.'.'.Input::file('background')->getClientOriginalExtension())->resize(Option::value('slider_width'), Option::value('slider_height'))->save();
			
			
			$filename2 = str_random(16);
            Input::file('background2')->move('modules/slider/slider/', $filename2.'.'.Input::file('background2')->getClientOriginalExtension());
            Image::open('modules/slider/slider/'.$filename2.'.'.Input::file('background2')->getClientOriginalExtension())->resize(Option::value('slider_width'), Option::value('slider_height'))->save();

            $title = Input::get('title');
            $slider = new Slider();

            $slider->title = !empty($title) ? $title : "Başlık Yok";
            $slider->content = Input::get('value');
            $slider->background = $filename.'.'.Input::file('background')->getClientOriginalExtension();
			$slider->background2 = $filename2.'.'.Input::file('background2')->getClientOriginalExtension();
            $slider->user_id = Auth::user()->id;
            $slider->save();

            return Redirect::to('component/slider')->with('message', 'Slider başarıyla oluşturuldu');
        }
        else{
            return Redirect::back()->withErrors($validator->messages());
        }

    }


    public function getEdit($id){

        $data['slider'] = Slider::findOrFail($id);

        return View::make('slider::edit',$data);

    }



    public function postEdit($id){

        $slider = Slider::findOrFail($id);

        $validator = Validator::make(Input::all(), [
            'background' => 'image',
			'background2' => 'image',
        ]);

        if($validator->passes()){

            if(Input::hasFile('background')){
                File::delete('modules/slider/slider/'. $slider->background);
                $filename = str_random(16);
                Input::file('background')->move('modules/slider/slider/', $filename.'.'.Input::file('background')->getClientOriginalExtension());
                Image::open('modules/slider/slider/'.$filename.'.'.Input::file('background')->getClientOriginalExtension())->resize(Option::value('slider_width'), Option::value('slider_height'))->save();
                $slider->background = $filename.'.'.Input::file('background')->getClientOriginalExtension();
            }
			
			if(Input::hasFile('background2')){
                File::delete('modules/slider/slider/'. $slider->background2);
                $filename2 = str_random(16);
                Input::file('background2')->move('modules/slider/slider/', $filename2.'.'.Input::file('background2')->getClientOriginalExtension());
                Image::open('modules/slider/slider/'.$filename2.'.'.Input::file('background2')->getClientOriginalExtension())->resize(Option::value('slider_width'), Option::value('slider_height'))->save();
                $slider->background2 = $filename2.'.'.Input::file('background2')->getClientOriginalExtension();
            }
            $title = Input::get('title');
            $slider->title = !empty($title) ? $title : "Başlık Yok";
            $slider->content = Input::get('value');
            $slider->save();

            return Redirect::to('component/slider/')->with('message', 'Slider başarıyla düzenlendi');
        }
        else{
            return Redirect::back()->withInput(Input::all())->withErrors($validator->messages());
        }

    }


    public function postUploader(){

        $validator = Validator::make(Input::all(), [
            'upload' => 'image|required'
        ]);

        if($validator->passes()){
            $filename = str_random(16);
            Input::file('upload')->move('modules/slider/slider/', $filename.'.'.Input::file('upload')->getClientOriginalExtension());
            return '<script>window.parent.CKEDITOR.tools.callFunction("'.Input::get('CKEditorFuncNum').'", "'.URL::to('modules/slider/slider/', $filename.'.'.Input::file('upload')->getClientOriginalExtension()).'");</script>';
        }
        return false;
    }


    public function getDelete($id){

        Slider::findOrFail($id)->delete();


        return Redirect::to('component/slider')->with('message', 'Slider Başarıyla Silindi');

    }

}
