@extends('layouts.wrap')

@section('title', $category->title.' - Düzenle')

@include('product::sidebar')


@section('_content')

<h1 class="title clearfix">{{ $category->title }} <a href="{{ URL::to('component/product/deletecategory/'.$category->id) }}" class="btn btn-danger btn-xs pull-right"><i class="fa fa-trash-o"></i> Kaldır</a></h1>

{{ Former::open()->method('POST')->action(URL::to('component/product/editcategory/'.$category->id)) }}

{{ Former::text('title')->label('Kategori Başlığı')->placeholder('Kategori Başlığı')->required(true)->value($category->title) }}


<div class="form-group">
<label>Üst Kategori</label>
<select class="form-control" name="parent_id">
<option value="0">** Yok **</option>
@foreach($parent as $c)
	<option @if($category->parent_id == $c->id) selected @endif  value="{{ $c->id }}">{{ $c->title }}</option>
@endforeach
</select>
</div>



<button type="submit" class="btn btn-danger">Değişiklikleri Kaydet</button>

{{ Former::close() }}

@stop