<?php

class ProductController extends \BaseController {

    public function getIndex(){

        $data['product'] = Product::paginate(Option::value('admin_paginate'));


        return View::make('product::home', $data);
    }


    public function getCreate(){
        $data['category'] = ProductCategory::where('lang_id', Session::get('lang_id'))->lists('title', 'id');
        return View::make('product::create', $data);
    }



    public function getCategory(){
        $data['category'] = ProductCategory::where('lang_id', Session::get('lang_id'))->paginate(15);
        return View::make('product::category', $data);
    }


    public function getCreatecategory(){

        $data['category'] = ProductCategory::where('lang_id', Session::get('lang_id'))->get();

        return View::make('product::createcategory', $data);
    }

    public function postCreatecategory(){

        $validator = Validator::make(Input::all(), [
            'title' => 'required'
        ]);

        if($validator->passes()){
            ProductCategory::create([
                'title'=> Input::get('title'),
                'parent_id' => Input::get('parent_id'),
                'lang_id' => Session::get('lang_id'),
                'slug' => Str::slug(Input::get('title'))
            ]);
            return Redirect::to('component/product')->with('message', 'Kategori Oluşturuldu');
        }
        return  Redirect::back()->withErrors($validator->messages())->withInput(Input::all());
    }


    public function getEditcategory($id){

        $data['category'] = ProductCategory::findOrFail($id);

        $data['parent'] = ProductCategory::where('lang_id', Session::get('lang_id'))->get();

        return View::make('product::editcategory', $data);

    }


    public function postEditcategory($id){

        $category = ProductCategory::findOrFail($id);

        $validator = Validator::make(Input::all(), [
            'title' => 'required'
        ]);

        if($validator->passes()){

            $category->title = Input::get('title');
            $category->parent_id = Input::get('parent_id');
            $category->slug = Input::get('title');
            $category->save();

            return Redirect::to('component/product/category')->with('message', 'Kategori Düzenlendi');
        }
        return  Redirect::back()->withErrors($validator->messages())->withInput(Input::all());

    }


    public function postUploadtech(){
            $validator = Validator::make(Input::all(), ['image' => 'required|image']);
            if($validator->passes()){
                $filename = str_random(16);
                Input::file('image')->move('modules/product/product', $filename.'.'.Input::file('image')->getClientOriginalExtension());
                $image =  Image::open('modules/product/product/'.$filename.'.'.Input::file('image')->getClientOriginalExtension());
                if($image->width > Option::value('product_point_image_width')){
                    $image->resize(Option::value('product_point_image_width'), null, true)->save();
                }
                return Response::json($filename.'.'.Input::file('image')->getClientOriginalExtension());
            }
    }


    public function postUploadcolor(){
        $validator = Validator::make(Input::all(), ['color' => 'required|image']);
        if($validator->passes()){
            $filename = str_random(16);
            Input::file('color')->move('modules/product/product', $filename.'.'.Input::file('color')->getClientOriginalExtension());
            $image =  Image::open('modules/product/product/'.$filename.'.'.Input::file('color')->getClientOriginalExtension());
            if($image->width > Option::value('product_color_width')){
                $image->resize(Option::value('product_color_width'), Option::value('product_color_height'))->save();
            }
            return Response::json($filename.'.'.Input::file('color')->getClientOriginalExtension());
        }
    }


    public function postCreate(){

        $validator = Validator::make(Input::all(),[
            'title' => 'required',
            'category_id' => 'required',
            'image' => 'required|image',
            'description' => 'required'
        ]);

        if($validator->passes()){
		
		$filename = str_random(16);
            Input::file('image')->move('modules/product/product/', $filename.'.'.Input::file('image')->getClientOriginalExtension());
            Image::open('modules/product/product/'.$filename.'.'.Input::file('image')->getClientOriginalExtension())->resize(230,230)->save();

            Product::create([
                'title' => Input::get('title'),
                'slug' => Str::slug(Input::get('title')),
                'category_id' => Input::get('category_id'),
                'cover' => $filename.'.'.Input::file('image')->getClientOriginalExtension(),
                'description' => Input::get('description'),
            ]);

            return Redirect::to('component/product')->with('message', 'Ürün Eklendi.');
        }

        return Redirect::back()->withErrors($validator->messages())->withInput(Input::all());
    }


    public function getEdit($id){

        $data['category'] = ProductCategory::where('lang_id', Session::get('lang_id'))->lists('title', 'id');

        $data['product'] = Product::findOrFail($id);

        return View::make('product::edit', $data);

    }

	
	public function getDelete($id){
	
		$p = Product::findOrFail($id);
		
		
		$p->delete();
	
		return Redirect::to('component/product/category');
	
	}
	
	public function getDeletecategory($id){
	
		$p = ProductCategory::findOrFail($id);
		$p->delete();
		
		Product::where("category_id", $id)->delete();
	
		return Redirect::to('component/product');
	
	}

    public function postEdit($id){

		
        $product = Product::findOrFail($id);


        $validator = Validator::make(Input::all(),[
            'title' => 'required',
            'category_id' => 'required',
            'description' => 'required',
        ]);

        if($validator->passes()){
		
		 if(Input::hasFile('image')){
                File::delete('modules/product/product/'. $product->cover);
                $filename = str_random(16);
                Input::file('image')->move('modules/product/product/', $filename.'.'.Input::file('image')->getClientOriginalExtension());
                Image::open('modules/product/product/'.$filename.'.'.Input::file('image')->getClientOriginalExtension())->resize(230,230)->save();
                $product->cover = $filename.'.'.Input::file('image')->getClientOriginalExtension();
            }		
                $product->title = Input::get('title');
				$product->slug = Str::slug(Input::get('title'));
				$product->category_id = Input::get('category_id');
                $product->description = Input::get('description');
				$product->save();
       
            return Redirect::to('component/product')->with('message', 'Ürün Düzenlendi.');
        }

        return Redirect::back()->withErrors($validator->messages())->withInput(Input::all());

    }




}
