@extends('layouts.wrap')





@section('title', 'Banka Hesapları')








@include('order::sidebar')








@section('_content')








<div id="component_page">


    <h1 class="title">Banka Hesapları</h1>





    @if(Session::has('message'))


    <div class="alert alert-success">{{ Session::get('message') }}</div>


    @endif


    @if($bank->count() > 0)


    <table class="table table-hover table-striped">


        <thead>


        <tr>


            <th>Başlık</th>


            <th>Bilgi</th>


        </tr>


        </thead>


        <tbody>


        @foreach($bank as $p)


        <tr>


            <td><a href="{{ URL::to('component/order/editbank/'. $p->id) }}">{{ $p->title }}<a></td>


            <td>{{ $p->value }}</td>


        </tr>


        @endforeach


        </tbody>


    </table>





    {{ $bank->links() }}


    @else


    <div class="alert alert-warning">


        <h4>Hiç Banka Hesabınız yok.</h4> <a href="{{ URL::to('component/order/addbank') }}" class="alert-link">Buradan ekleyin</a>


    </div>


    @endif








</div>











@stop