<?php





class OrderController extends \BaseController {





    public function getIndex(){


        $data['order'] = Order::orderBy('id', 'desc')->paginate(Option::value('admin_paginate'));


        return View::make('order::home', $data);


    }





    public function getBank(){


        $data['bank'] = OrderBank::paginate(Option::value('admin_paginate'));


        return View::make('order::bank',$data);


    }





    public function getShow($id){


        $data['order'] = Order::findOrFail($id);


        return View::make('order::show', $data);


    }





    public function getAddbank(){


        return View::make('order::addBank');


    }





    public function getEditbank($id){


        $data['bank'] = OrderBank::findOrFail($id);


        return View::make('order::editBank', $data);


    }





    public function getDeletebank($id){


        OrderBank::findOrFail($id)->delete();


        return Redirect::to('component/order/bank');


    }





    public function postEditbank($id){


        $validator = Validator::make(Input::all(), [


            'title' => 'required',


            'value' => 'required'


        ]);


        if($validator->passes()){


            OrderBank::where('id', $id)->update([


                'title' => Input::get('title'),


                'value' => Input::get('value'),


                'lang_id' => Session::get('lang_id')


            ]);





            return Redirect::to('component/order/bank')->with('message', 'Banka Başarıyla Düzenlendi');


        }





        return Redirect::back()->withErrors($validator->messages())->withInput(Input::all());


    }





    public function postAddbank(){


        $validator = Validator::make(Input::all(), [


            'title' => 'required',


            'value' => 'required'


        ]);


        if($validator->passes()){


            OrderBank::create([


                'title' => Input::get('title'),


                'value' => Input::get('value'),


                'lang_id' => Session::get('lang_id')


            ]);





            return Redirect::to('component/order/bank')->with('message', 'Banka Başarıyla Eklendi');


        }





        return Redirect::back()->withErrors($validator->messages())->withInput(Input::all());


    }








    public function postSiparis(){





        $validate = Validator::make(Input::all(), [


            'name' => 'required',


            'email' => 'email',


            'company' => 'required',


            'phone' => 'numeric',


            'product' => 'required',


        ]);








        if($validate->passes()){





            Order::create([


                'name' => Input::get('name'),


                'email' => Input::get('email'),


                'company' => Input::get('company'),


                'phone' => Input::get('phone'),


                'address' => Input::get('address'),


                'products' => json_encode(Input::get('product')),


                'message' => Input::get('message')


            ]);





            /*$message = urlencode(Input::get('name')." urun siparis etti. yonetimden kontrol ediniz.");


            file_get_contents("https://vairosoft.com/api/sms/send?phones=".Option::value('sms_number')."&key=".Option::value('sms_key')."&message=".$message);*/

            $vairo_veri = DB::connection('mysql_vairo')->table('project')->where('id', 24)->first();

            if($vairo_veri->sms_limit < 10 and $vairo_veri->sms_limit > 0){

                $deger = DB::table('options')->where('option', 'sms_number')->first();
                $number = array($deger->value);

                $veriler = array(
                    'apiNo' =>'1',
                    'user' =>'enuygun9547',
                    'pass' =>'enuygun9547',
                    'mesaj'=> 'Kalan SMS Krediniz: '.$vairo_veri->sms_limit,
                    'numaralar' => $number,
                    'baslik' => "Vairosoft"
                );

                $hatirlatma = $this->sms_gonder("http://kurecell.com.tr/kurecellapiV2/api-center/",$veriler);

                $durum = $this->get_string_between($hatirlatma, "|", ":");

                if($durum == "OK"){

                    $yeni_bakiye = $vairo_veri->sms_limit - 1;
                    DB::connection('mysql_vairo')->table('project')->where('id', 24)->update(array('sms_limit' => $yeni_bakiye));
                }
            }

            //////////////////////////////////////////////////////

            if($vairo_veri->sms_limit > 0){

                // SMS Gönderim
                $message = Input::get('name')." urun siparis etti. yonetimden kontrol ediniz.";
                $baslik = "SİPARİŞ";
                $deger = DB::table('options')->where('option', 'sms_number')->first();
                $number = array($deger->value);

                $veriler = array(
                    'apiNo' =>'1',
                    'user' =>'enuygun9547',
                    'pass' =>'enuygun9547',
                    'mesaj'=> $message,
                    'numaralar' => $number,
                    'baslik' => $baslik
                );

                $mesaj = $this->sms_gonder("http://kurecell.com.tr/kurecellapiV2/api-center/",$veriler);

                $durum2 = $this->get_string_between($mesaj, "|", ":");
                if($durum2 == "OK"){

                    $vairo_veri = DB::connection('mysql_vairo')->table('project')->where('id', 24)->first(); // Güncel bakiye için tekrar sorgu atıyoruz.

                    $yeni_bakiye2 = $vairo_veri->sms_limit - 1;
                    DB::connection('mysql_vairo')->table('project')->where('id', 24)->update(array('sms_limit' => $yeni_bakiye2));
                }
            }


            // Email Gönder

            $deger = DB::table('options')->where('option', 'eposta')->first();

            $eposta = $deger->value;


            $mesaj_bilgi = array();


            $mesaj_bilgi['name'] = Input::get('name');
            $mesaj_bilgi['email'] = Input::get('email');
            $mesaj_bilgi['phone'] = Input::get('phone');
            $mesaj_bilgi['company'] = Input::get('company');
            $mesaj_bilgi['address'] = Input::get('address');
            $mesaj_bilgi['product'] = Input::get('product');
            $mesaj_bilgi['message'] = Input::get('message');

            Mail::send('emails.siparis', array('icerik' => $mesaj_bilgi), function($message) use ($eposta) {

                $message->to(array($eposta), 'Vairosoft')->subject('ÖZGÜN TARIM - Yeni Sipariş Mesajı');
            });



            return Redirect::back()->with('message', 'Talebiniz Alındı. En Kısa sürede geri dönüş yapılacak <br> Teşekkür Ederiz.');


        }



        return Redirect::back()->withErrors($validate->messages())->withInput(Input::all());


    }


    function sms_gonder($Url,$strRequest) {
        $ch=curl_init();
        $veri = http_build_query($strRequest);
        curl_setopt($ch, CURLOPT_URL, $Url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1) ;
        curl_setopt($ch, CURLOPT_POSTFIELDS,$veri);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }


    function get_string_between($string, $start, $end){
        $string = " ".$string;
        $ini = strpos($string,$start);
        if ($ini == 0) return "";
        $ini += strlen($start);
        $len = strpos($string,$end,$ini) - $ini;
        return substr($string,$ini,$len);
    }








}


