<?php

class NewsController extends \BaseController {

    public function getIndex(){

        $data['news'] = News::where('lang', Session::get('lang_id'))->paginate(Option::value('admin_paginate'));

        return View::make('news::home', $data);


    }


    public function getCreate(){

        return View::make('news::create');

    }

    public function getEdit($id){

        $data['news'] = News::findOrFail($id);

        return View::make('news::edit', $data);

    }


    public function postEdit($id){

        $news = News::findOrFail($id);

        $validator = Validator::make(Input::all(), [
            'title' => 'required',
            'cover' => 'image',
            'value' => 'required'
        ]);

        if($validator->passes()){

            if(Input::hasFile('cover')){
                File::delete('modules/news/news/'. $news->cover);
                $filename = str_random(16);
                Input::file('cover')->move('modules/news/news/', $filename.'.'.Input::file('cover')->getClientOriginalExtension());
                Image::open('modules/news/news/'.$filename.'.'.Input::file('cover')->getClientOriginalExtension())->resize(Option::value('news_width'), Option::value('news_height'))->save();
                $news->cover = $filename.'.'.Input::file('cover')->getClientOriginalExtension();
            }

            $news->lang = Session::get('lang_id');
            $news->title = Input::get('title');
            $news->value = Input::get('value');
            $news->user_id = Auth::user()->id;
            $news->save();

            return Redirect::to('component/news')->with('message', 'Haber başarıyla düzenlendi');
        }
        else{
            return Redirect::back()->withErrors($validator->messages());
        }

    }


    public function postCreate(){

        $validator = Validator::make(Input::all(), [
            'title' => 'required',
            'cover' => 'required|image',
            'value' => 'required'
        ]);

        if($validator->passes()){
            $filename = str_random(16);
            Input::file('cover')->move('modules/news/news/', $filename.'.'.Input::file('cover')->getClientOriginalExtension());
            Image::open('modules/news/news/'.$filename.'.'.Input::file('cover')->getClientOriginalExtension())->resize(Option::value('news_width'), Option::value('news_height'))->save();

            $slider = new News();
            $slider->lang = Session::get('lang_id');
            $slider->title = Input::get('title');
            $slider->value = Input::get('value');
            $slider->cover = $filename.'.'.Input::file('cover')->getClientOriginalExtension();
            $slider->user_id = Auth::user()->id;
            $slider->save();

            return Redirect::to('component/news')->with('message', 'Haber başarıyla oluşturuldu');
        }
        else{
            return Redirect::back()->withErrors($validator->messages());
        }

    }




    public function postUploader(){
        $validator = Validator::make(Input::all(), [
            'upload' => 'image|required'
        ]);

        if($validator->passes()){
            $filename = str_random(16);
            Input::file('upload')->move('modules/news/news/', $filename.'.'.Input::file('upload')->getClientOriginalExtension());
            return '<script>window.parent.CKEDITOR.tools.callFunction("'.Input::get('CKEditorFuncNum').'", "'.URL::to('modules/news/news/', $filename.'.'.Input::file('upload')->getClientOriginalExtension()).'");</script>';
        }
        return false;
    }
	
	 public function getDelete($id){
	News::findOrFail($id)->delete();
        return Redirect::to('component/news')->with('message', 'Haber Başarıyla Silindi');
    }



}
