<?php



class GalleryController extends \BaseController {





	public function getIndex()

	{

        $data['gallery'] = Gallery::orderBy('id', 'desc')->where('lang', Session::get('lang_id'))->paginate(Option::value('admin_paginate'));

		return View::make('gallery::home', $data);

	}





	public function getCreate()

	{

        return View::make('gallery::create');

	}





    public function postUpload(){

        $response = [];

        foreach(Input::file('images') as $file){

            $rules = array(

                'images' => 'required|image'

            );

            $validator = Validator::make(array('images'=> $file), $rules);

            if($validator->passes()){



                $filename = str_random(16);

                $file->move('modules/gallery/userdata', $filename.'.'.$file->getClientOriginalExtension());

                $image =  Image::open('modules/gallery/userdata/'.$filename.'.'.$file->getClientOriginalExtension());

                if($image->width > Option::value('gallery_image_width')){

                    $image->resize(Option::value('gallery_image_width'), null, true)->save();

                }



                Image::make('modules/gallery/userdata/'.$filename.'.'.$file->getClientOriginalExtension())->resize(Option::value('gallery_image_th_width'), null, true)->save('modules/gallery/userdata/th_'.$filename.'.'.$file->getClientOriginalExtension());

                array_push($response, $filename.'.'.$file->getClientOriginalExtension());

            }

        }



        return Response::json($response);



    }







    public function postSave(){



        $validator = Validator::make(Input::all(), [

            'images' => 'required',

            'title' => 'required'

        ]);



        if($validator->passes()){



            $gallery = Gallery::create(['images' => json_encode(Input::get('description')), 'value' => Input::get('value'), 'title' => Input::get('title'), 'user_id' => Auth::user()->id, 'lang' => Session::get('lang_id') ]);

            File::makeDirectory('modules/gallery/gallery/'.$gallery->id);

            foreach(Input::get('images') as $image){

                File::move('modules/gallery/userdata/'.$image, 'modules/gallery/gallery/'.$gallery->id.'/'.$image);

                File::move('modules/gallery/userdata/th_'.$image, 'modules/gallery/gallery/'.$gallery->id.'/th_'.$image);

            }



            return Redirect::to('component/gallery')->with('message', 'Resimler Başarıyla Eklendi');



        }

        else{

            return Redirect::back()->withInput(Input::all())->withErrors($validator->messages());

        }



    }





    public function getEdit($id){

        $data['gallery'] = Gallery::findOrFail($id);

        return View::make('gallery::edit', $data);

    }





    public function getDelete($id){



        Gallery::findOrFail($id)->delete();

        File::deleteDirectory('modules/gallery/gallery/'.$id);



        return Redirect::to('component/gallery')->with('message', 'Resimler Başarıyla Silindi');



    }



    public function postEdit($id){

        $validator = Validator::make(Input::all(), [

            'images' => 'required',

            'title' => 'required'

        ]);



        if($validator->passes()){



            $gallery = Gallery::findOrFail($id);



            $old_images = array_keys((array)$gallery->images);



            $new_images = Input::get('images');



            $gallery->title = Input::get('title');

            $gallery->user_id = Auth::user()->id;

            $gallery->lang = Session::get('lang_id');

            $gallery->value = Input::get('value');

            $gallery->images = json_encode(Input::get('description'));





            $add = array_diff($new_images, $old_images);



            foreach($add as $up){

                File::move('modules/gallery/userdata/'.$up, 'modules/gallery/gallery/'.$gallery->id.'/'.$up);

                File::move('modules/gallery/userdata/th_'.$up, 'modules/gallery/gallery/'.$gallery->id.'/th_'.$up);

            }



            $remove = array_diff($old_images, $new_images);



            foreach($remove as $rem){

                File::delete('modules/gallery/gallery/'.$gallery->id.'/th_'.$rem);

                File::delete('modules/gallery/gallery/'.$gallery->id.'/'.$rem);

            }



            $gallery->save();



            return Redirect::back()->with('message', 'Değişiklikler Başarıyla Kaydedildi');



        }

        else{

            return Redirect::back()->withInput(Input::all())->withErrors($validator->messages());

        }





    }





}

