<?php

class ContactController extends \BaseController {

	public function getIndex(){

        $data['contact'] = Contact::paginate(Option::value('admin_paginate'));

        return View::make('contact::home',$data);
    }


    public function getCreate(){

        return View::make('contact::create');

    }


    public function postCreate(){

        $validator = Validator::make(Input::all(), [
            'title' => 'required',
            'address' => 'required',
            'phone' => 'required',
            'map' => 'required'
        ]);


        if($validator->passes()){

            Contact::create([
                'title' => Input::get('title'),
                'address' => Input::get('address'),
                'phone' => Input::get('phone'),
                'fax' => Input::get('fax'),
                'email' => Input::get('email'),
                'map' => Input::get('map')
            ]);

            return Redirect::to('component/contact')->with('message', 'Adres Başarıyla Eklendi');

        }

        return Redirect::back()->withErrors($validator)->withInput(Input::all());

    }



    public function getEdit($id){

        $data['contact'] = Contact::findOrFail($id);

        return View::make('contact::edit', $data);

    }


    public function postEdit($id){

        $validator = Validator::make(Input::all(), [
            'title' => 'required',
            'address' => 'required',
            'phone' => 'required',
            'map' => 'required'
        ]);


        if($validator->passes()){

            $contact = Contact::findOrFail($id);

            $contact->title = Input::get('title');
            $contact->address = Input::get('address');
            $contact->phone = Input::get('phone');
            $contact->fax = Input::get('fax');
            $contact->email = Input::get('email');
            $contact->map = Input::get('map');

            $contact->save();

            return Redirect::to('component/contact')->with('message', 'Adres Başarıyla Düzenlendi');

        }

        return Redirect::back()->withErrors($validator)->withInput(Input::all());


    }



    public function getList(){

        $data['list'] = ContactForm::paginate(Option::value('admin_paginate'));

        return View::make('contact::list', $data);

    }



    public function getShow($id){

        $data['form'] = ContactForm::findOrFail($id);


        return View::make('contact::show', $data);

    }


    public function getDelete($id){
        Contact::findOrFail($id)->delete();
        return Redirect::to('component/contact');
    }


    public function postIletisim(){
        $validator = Validator::make(Input::all(), [
            'name' => 'required',
            'surname' => 'required',
            'email' => 'email',
            'phone' => 'required|numeric',
            'subject' => 'required',
            'message' => 'required'
        ]);

        if($validator->passes()){
            ContactForm::create([
				'name' => Input::get('name'),
                'surname' => Input::get('surname'),
                'email' => Input::get('email'),
                'phone' => Input::get('phone'),
                'subject' => Input::get('subject'),
                'message' => Input::get('message')
            ]);
			
			$vairo_veri = DB::connection('mysql_vairo')->table('project')->where('id', 24)->first();
			
			if($vairo_veri->sms_limit < 10 and $vairo_veri->sms_limit > 0){

            $deger = DB::table('options')->where('option', 'sms_number')->first();
            $number = array($deger->value);

			$veriler = array(					
				'apiNo' =>'1',                					
				'user' =>'enuygun9547',                					
				'pass' =>'enuygun9547',                					
				'mesaj'=> 'Kalan SMS Krediniz: '.$vairo_veri->sms_limit,                					
				'numaralar' => $number,                					
				'baslik' => "Vairosoft"            				
			);							
			
				$hatirlatma = $this->sms_gonder("http://kurecell.com.tr/kurecellapiV2/api-center/",$veriler);
				
				$durum = $this->get_string_between($hatirlatma, "|", ":");
				
				if($durum == "OK"){
					
					$yeni_bakiye = $vairo_veri->sms_limit - 1;
					DB::connection('mysql_vairo')->table('project')->where('id', 24)->update(array('sms_limit' => $yeni_bakiye));
				}
			}		
			
			
			if($vairo_veri->sms_limit > 0){								
			
				// SMS Gönderim				
				$message = Input::get('name')." ".Input::get('surname')." iletisim istegi gonderdi yonetimden kontrol ediniz";
                $baslik = "ILETISIM";
                $deger = DB::table('options')->where('option', 'sms_number')->first();
				$number = array($deger->value);

				$veriler = array(					
					'apiNo' =>'1',                					
					'user' =>'enuygun9547',                					
					'pass' =>'enuygun9547',                					
					'mesaj'=> $message,                					
					'numaralar' => $number,                					
					'baslik' => $baslik            				
				);																				
				
                $mesaj = $this->sms_gonder("http://kurecell.com.tr/kurecellapiV2/api-center/",$veriler);

                $durum2 = $this->get_string_between($mesaj, "|", ":");
                if($durum2 == "OK"){

                    $vairo_veri = DB::connection('mysql_vairo')->table('project')->where('id', 24)->first(); // Güncel bakiye için tekrar sorgu atıyoruz.

                    $yeni_bakiye2 = $vairo_veri->sms_limit - 1;
                    DB::connection('mysql_vairo')->table('project')->where('id', 24)->update(array('sms_limit' => $yeni_bakiye2));
                }


			}

            // Email Gönder

            $deger = DB::table('options')->where('option', 'eposta')->first();

            $eposta = $deger->value;


            $mesaj_bilgi = array();

            $mesaj_bilgi['name'] = Input::get('name')." ".Input::get('surname');
            $mesaj_bilgi['email'] = Input::get('email');
            $mesaj_bilgi['phone'] = Input::get('phone');
            $mesaj_bilgi['subject'] = Input::get('subject');
            $mesaj_bilgi['message'] = Input::get('message');

            Mail::send('emails.iletisim', array('icerik' => $mesaj_bilgi), function($message) use ($eposta) {

                $message->to(array($eposta), 'Vairosoft')->subject('ÖZGÜN TARIM - Yeni İletişim Mesajı');
            });
						
            return Redirect::back()->with('message', 'Talebiniz Alındı teşekkür ederiz.');
        }		
        return Redirect::back()->withErrors($validator->messages())->withInput(Input::all());
    }		
	
	function sms_gonder($Url,$strRequest) {							
		$ch=curl_init();					
		$veri = http_build_query($strRequest);					
		curl_setopt($ch, CURLOPT_URL, $Url);					
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);					
		curl_setopt($ch, CURLOPT_POST, 1) ;					
		curl_setopt($ch, CURLOPT_POSTFIELDS,$veri);					
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);					
		$result = curl_exec($ch);					
		curl_close($ch);					
		return $result;				
	}
	
	
	function get_string_between($string, $start, $end){
		$string = " ".$string;
		$ini = strpos($string,$start);
		if ($ini == 0) return "";
		$ini += strlen($start);
		$len = strpos($string,$end,$ini) - $ini;
		return substr($string,$ini,$len);
	}
}
